IF EXISTS ( SELECT * FROM SYS.OBJECTS  WHERE NAME = 'P_BUSCA_TBL_DESC_GLB_ARV_MERC_FILTROS')
	BEGIN 
		DROP PROCEDURE P_BUSCA_TBL_DESC_GLB_ARV_MERC_FILTROS
	END
GO

CREATE PROC [DBO].[P_BUSCA_TBL_DESC_GLB_ARV_MERC_FILTROS]
	@CD_EMP				INT
	,@CD_USU			INT
	,@LISTA_FILIAIS		VARCHAR( MAX )

AS

/*

EXEC P_BUSCA_TBL_DESC_GLB_ARV_MERC_FILTROS @CD_EMP = 1 , @CD_USU = 4 , @LISTA_FILIAIS = '1,2,3,4,5,6,7,8,9,10,11,12,13'

29.04.2024 - GUSTAVO POSTIGO - INICIO COM BASE EM  UFD_BUSCA_EST_PROD_TBL_DESC
*/

SET NOCOUNT ON

IF OBJECT_ID( 'TEMPDB..#FILIAL_FILTRO' ) IS NOT NULL
	DROP TABLE #FILIAL_FILTRO

SELECT NUMBER AS CD_FILIAL
	INTO #FILIAL_FILTRO
	FROM DBO.F_LISTAEMTABELA( @LISTA_FILIAIS )


IF OBJECT_ID( 'TEMPDB..#GLB_FILTRO' ) IS NOT NULL
	DROP TABLE #GLB_FILTRO

SELECT *
	INTO #GLB_FILTRO
	--SELECT *
	FROM GLB_ARV_MERC_FILTROS  
	WHERE CD_EMP = @CD_EMP
		AND CD_USU = @CD_USU

CREATE INDEX X1 ON #GLB_FILTRO ( CD_EMP , CD_PROD )

IF OBJECT_ID( 'TEMPDB..#PROD_FILTRO' ) IS NOT NULL
	DROP TABLE #PROD_FILTRO

SELECT F.*
		, A.CD_ARV_MERC_LINHA 
		, A.CD_ARV_MERC_CATEG 
		, P.CD_FABRIC 
		, A.CD_MC 
		, A.CD_ARV_MERC_FAMILIA
		INTO #PROD_FILTRO
	FROM #GLB_FILTRO F
	JOIN EST_PROD  P
		ON P.CD_EMP = F.CD_EMP
		AND P.CD_PROD = F.CD_PROD
	JOIN EST_PROD_EST_ARV_MERCADOLOGICA A 
		ON A.CD_EMP    = P.CD_EMP 
		AND A.CD_PROD   = P.CD_PROD

IF OBJECT_ID( 'TEMPDB..#TBL_DESC' ) IS NOT NULL
	DROP TABLE #TBL_DESC

CREATE TABLE #TBL_DESC
	( NIVEL INT,
	CD_PROD INT,
	CD_FILIAL INT,
	CD_EMP INT,
	CD_TBL INT,
	PERC_DESC MONEY,
	PERC_DESC_MAX MONEY,
	PERC_DESC_LIMITE MONEY,
	DS_TBL_DESC VARCHAR(200))

CREATE INDEX X1 ON #TBL_DESC ( CD_EMP , CD_FILIAL , CD_PROD , NIVEL , CD_TBL )
CREATE INDEX X2 ON #TBL_DESC ( CD_EMP , CD_FILIAL , CD_PROD , PERC_DESC , PERC_DESC_MAX , PERC_DESC_LIMITE )
CREATE INDEX X3 ON #TBL_DESC ( CD_EMP , CD_FILIAL , CD_PROD , CD_TBL )

INSERT INTO #TBL_DESC
SELECT
	99 NIVEL,
	PD.CD_PROD,
	F.CD_FILIAL,
	F.CD_EMP,
	F.CD_TBL_DESC,
	F.PERC_DESC,
	F.PERC_DESC_MAX,
	F.PERC_DESC_LIMITE,
	D.DS_TBL_DESC
FROM #PROD_FILTRO  T
	INNER JOIN EST_PROD_TBL_DESC_EST_PROD PD ON
	PD.CD_EMP = T.CD_EMP AND
	PD.CD_PROD = T.CD_PROD
	JOIN EST_PROD_TBL_DESC D
		ON D.CD_EMP = PD.CD_EMP
		AND D.CD_TBL_DESC = PD.CD_TBL_DESC
	INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL F ON 
	D.CD_EMP		= F.CD_EMP AND
	D.CD_TBL_DESC	= F.CD_TBL_DESC 
	AND F.CD_FILIAL IN ( SELECT CD_FILIAL FROM #FILIAL_FILTRO )
WHERE 
	D.CD_TP_DESCONTO IN(1,18,23)
	AND CONVERT( DATE , GETDATE() ) BETWEEN D.DT_INI  AND D.DT_FIM ;


INSERT INTO #TBL_DESC
SELECT 
	6 NIVEL,
	T.CD_PROD,
	F.CD_FILIAL,
	F.CD_EMP,
	D.CD_TBL_DESC,
	D.PERC_DESC,
	D.PERC_DESC_MAX,
	D.PERC_DESC_LIMITE,
	TB.DS_TBL_DESC
FROM #PROD_FILTRO  T -- ( SELECT DISTINCT CD_EMP , CD_ARV_MERC_LINHA FROM #PROD_FILTRO ) T
	JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_LINHA  D
		ON D.CD_EMP = T.CD_EMP
		AND D.CD_ARV_MERC_LINHA = T.CD_ARV_MERC_LINHA
	INNER JOIN  EST_PROD_TBL_DESC TB ON 
	D.CD_EMP = TB.CD_EMP AND
	D.CD_TBL_DESC	= TB.CD_TBL_DESC 
	INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL F ON 
	D.CD_EMP = F.CD_EMP AND
	D.CD_TBL_DESC	= F.CD_TBL_DESC 
	AND F.CD_FILIAL IN ( SELECT CD_FILIAL FROM #FILIAL_FILTRO )
	WHERE
    TB.CD_TP_DESCONTO IN(1,18,23)
    AND CONVERT( DATE , GETDATE() ) BETWEEN TB.DT_INI  AND TB.DT_FIM ;


INSERT INTO #TBL_DESC
SELECT
	5 NIVEL,
	T.CD_PROD,
	F.CD_FILIAL,
	F.CD_EMP,
	D.CD_TBL_DESC,
	D.PERC_DESC,
	D.PERC_DESC_MAX,
	D.PERC_DESC_LIMITE,
	TB.DS_TBL_DESC
FROM  #PROD_FILTRO  T
	JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_CATEGORIA  D
	   ON D.CD_EMP = T.CD_EMP
		AND D.CD_ARV_MERC_CATEG = T.CD_ARV_MERC_CATEG
	INNER JOIN  EST_PROD_TBL_DESC TB ON 
	D.CD_EMP		= TB.CD_EMP AND
	D.CD_TBL_DESC	= TB.CD_TBL_DESC 
	INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL F ON 
	D.CD_EMP		= F.CD_EMP AND
	D.CD_TBL_DESC	= F.CD_TBL_DESC 
	AND F.CD_FILIAL IN ( SELECT CD_FILIAL FROM #FILIAL_FILTRO )
WHERE TB.CD_TP_DESCONTO IN(1,18,23)
    AND CONVERT( DATE , GETDATE() ) BETWEEN TB.DT_INI  AND TB.DT_FIM ;

INSERT INTO #TBL_DESC
SELECT 
	4 NIVEL,
	T.CD_PROD,
	F.CD_FILIAL,
	F.CD_EMP,
	D.CD_TBL_DESC,
	D.PERC_DESC,
	D.PERC_DESC_MAX,
	D.PERC_DESC_LIMITE,
	TB.DS_TBL_DESC
FROM  #PROD_FILTRO  T
	JOIN EST_PROD_TBL_DESC_EST_PROD_FABRIC  D
		ON D.CD_EMP = T.CD_EMP
		AND D.CD_FABRIC = T.CD_FABRIC
   INNER JOIN  EST_PROD_TBL_DESC TB ON 
	D.CD_EMP		= TB.CD_EMP AND
	D.CD_TBL_DESC	= TB.CD_TBL_DESC 
	INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL F ON 
	D.CD_EMP		= F.CD_EMP AND
	D.CD_TBL_DESC	= F.CD_TBL_DESC 
	AND F.CD_FILIAL IN ( SELECT CD_FILIAL FROM #FILIAL_FILTRO )
WHERE
    TB.CD_TP_DESCONTO IN(1,18,23)
    AND CONVERT( DATE , GETDATE() ) BETWEEN TB.DT_INI  AND TB.DT_FIM ;
	
INSERT INTO #TBL_DESC
SELECT 
	3 NIVEL,
	T.CD_PROD,
	F.CD_FILIAL,
	F.CD_EMP,
	D.CD_TBL_DESC,
	D.PERC_DESC,
	D.PERC_DESC_MAX,
	D.PERC_DESC_LIMITE,
	TB.DS_TBL_DESC
FROM  #PROD_FILTRO  T
	JOIN EST_PROD_TBL_DESC_EST_MC  D
		ON D.CD_EMP = T.CD_EMP
		AND D.CD_MC = T.CD_MC
	INNER JOIN  EST_PROD_TBL_DESC TB ON 
	D.CD_EMP		= TB.CD_EMP AND
	D.CD_TBL_DESC	= TB.CD_TBL_DESC 
	INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL F ON 
	D.CD_EMP		= F.CD_EMP AND
	D.CD_TBL_DESC	= F.CD_TBL_DESC 
	AND F.CD_FILIAL IN ( SELECT CD_FILIAL FROM #FILIAL_FILTRO )
WHERE TB.CD_TP_DESCONTO IN(1,18,23)
    AND CONVERT( DATE , GETDATE() ) BETWEEN TB.DT_INI  AND TB.DT_FIM ;
	
INSERT INTO #TBL_DESC
SELECT 
    2 NIVEL,
    T.CD_PROD,
    F.CD_FILIAL,
	F.CD_EMP,
    D.CD_TBL_DESC,
    D.PERC_DESC,
    D.PERC_DESC_MAX,
    D.PERC_DESC_LIMITE,
	TB.DS_TBL_DESC
FROM  #PROD_FILTRO T
    JOIN EST_PROD_TBL_DESC_EST_ARV_MERC_FAMILIA  D
		ON D.CD_EMP = T.CD_EMP
		AND D.CD_ARV_MERC_FAMILIA = T.CD_ARV_MERC_FAMILIA
    INNER JOIN  EST_PROD_TBL_DESC TB ON 
    D.CD_EMP		= TB.CD_EMP AND
    D.CD_TBL_DESC	= TB.CD_TBL_DESC 
    INNER JOIN EST_PROD_TBL_DESC_PRC_FILIAL F ON 
    D.CD_EMP		= F.CD_EMP AND
    D.CD_TBL_DESC	= F.CD_TBL_DESC
	 AND F.CD_FILIAL IN ( SELECT CD_FILIAL FROM #FILIAL_FILTRO )
WHERE
    TB.CD_TP_DESCONTO IN(1,18,23)
    AND CONVERT( DATE , GETDATE() ) BETWEEN TB.DT_INI  AND TB.DT_FIM ;


INSERT INTO #TBL_DESC
SELECT 
	1 NIVEL,
	T.CD_PROD,
	T.CD_FILIAL,
	T.CD_EMP,
	D.CD_TBL_DESC,
	D.PERC_DESC,
	D.PERC_DESC_MAX,
	D.PERC_DESC_LIMITE,
	T.DS_TBL_DESC 
FROM  
	EST_PROD_TBL_DESC_EST_PROD  D
	INNER JOIN  EST_PROD   P ON 
	D.CD_EMP		= P.CD_EMP AND
	D.CD_PROD = P.CD_PROD
	INNER JOIN #TBL_DESC T ON  
	P.CD_PROD		= T.CD_PROD AND
	D.CD_TBL_DESC	= T.CD_TBL
	AND T.NIVEL=99;
	
	INSERT INTO	#TBL_DESC
	SELECT
		7 AS NIVEL,
		TP.CD_PROD,
		TF.CD_FILIAL,
		TF.CD_EMP,
		T.CD_PRECO_PRG,
		TP.PERC_DESC,
		TP.PERC_DESC AS PERC_DESC_MAX,
		TP.PERC_DESC AS PERC_DESC_LIMITE,
		'DESCONTO PROGRAMADO'
	FROM #PROD_FILTRO  TEMP
		JOIN EST_PROD_PRECO_DESC_PRG_CPL TP
			ON TP.CD_EMP = TEMP.CD_EMP
			AND TP.CD_PROD = TEMP.CD_PROD
		INNER JOIN EST_PROD_PRECO_DESC_PRG T ON
			T.CD_PRECO_PRG = TP.CD_PRECO_PRG
		INNER JOIN EST_PROD_PRECO_DESC_PRG_PRC_FILIAL TF ON
			T.CD_PRECO_PRG = TF.CD_PRECO_PRG
			AND TF.CD_FILIAL IN ( SELECT CD_FILIAL FROM #FILIAL_FILTRO )

	WHERE
		CONVERT( DATE , GETDATE() ) BETWEEN T.DT_INI AND T.DT_VENCTO


    /******************************************************************/
    --VALIDACAO FORMA DE PAGAMENTO A VISTA  
    /******************************************************************/
	   --DELETA FORMAS DE PGTO A PRAZO
	   DELETE FROM T
	   FROM
		  #TBL_DESC T
		  JOIN EST_PROD_TBL_DESC_FORMA_PGTO P ON 
		  T.CD_TBL=P.CD_TBL_DESC
		  AND T.CD_EMP = P.CD_EMP
		  JOIN EST_FORMA_PGTO V ON
		  P.CD_EMP=V.CD_EMP AND
		  P.CD_FORMA_PGTO=V.CD_FRM_PGTO
	   WHERE
		  V.TP_COND=1 --PRAZO
		  AND NOT EXISTS(SELECT
						  CD_TBL
						  FROM 
							 #TBL_DESC
							 JOIN EST_PROD_TBL_DESC_FORMA_PGTO P ON 
							 T.CD_TBL=P.CD_TBL_DESC
							 AND T.CD_EMP = P.CD_EMP
							 JOIN EST_FORMA_PGTO V ON
							 P.CD_EMP=V.CD_EMP AND
							 P.CD_FORMA_PGTO=V.CD_FRM_PGTO
							 WHERE V.TP_COND=0 --A VISTA
							 )
		  AND V.REGRA_DESCONTO <>3 --QUE NAO SEJA MELHOR DESCONTO;

    /******************************************************************/

SELECT TF.*
	FROM	(
				 SELECT CD_EMP , CD_FILIAL , CD_PROD , MIN( NIVEL ) AS NIVEL
					FROM #TBL_DESC
					GROUP BY CD_EMP , CD_FILIAL , CD_PROD
			) N
	JOIN	(
				 SELECT CD_EMP , CD_FILIAL , CD_PROD , NIVEL , MAX( PERC_DESC ) AS PERC_DESC
					FROM #TBL_DESC
					GROUP BY CD_EMP , CD_FILIAL , CD_PROD , NIVEL
			) P
		ON P.CD_EMP = N.CD_EMP
		AND P.CD_FILIAL = N.CD_FILIAL
		AND P. CD_PROD = N.CD_PROD
		AND P.NIVEL = P.NIVEL
	JOIN	(
				 SELECT CD_EMP , CD_FILIAL , CD_PROD , NIVEL , PERC_DESC , MIN( CD_TBL ) AS CD_TBL
					FROM #TBL_DESC
					GROUP BY CD_EMP , CD_FILIAL , CD_PROD , NIVEL , PERC_DESC 
			) T
		ON T.CD_EMP = P.CD_EMP
		AND T.CD_FILIAL = P.CD_FILIAL
		AND T. CD_PROD = P.CD_PROD
		AND T.NIVEL = P.NIVEL
		AND T.PERC_DESC = P.PERC_DESC
	JOIN #TBL_DESC TF
		ON TF.CD_EMP = T.CD_EMP
		AND TF.CD_FILIAL = T.CD_FILIAL
		AND TF. CD_PROD = T.CD_PROD
		AND TF.NIVEL = T.NIVEL
		AND TF.PERC_DESC = T.PERC_DESC
		AND TF.CD_TBL = T.CD_TBL




--FIM
GO


